# 画面設計書 10-Resource Browser

## 概要

本ドキュメントは、VBCorLibプロジェクトのサンプルアプリケーション「Resource Browser」の画面設計書です。

### 本画面の処理概要

Resource BrowserはVBCorLibライブラリが提供するResourceReader、WinResourceReaderクラスを使用して、RESファイルおよびEXE/DLL/OCXファイル内のリソースを閲覧する画面です。ListViewコントロールでリソース一覧を表示し、PictureBoxでアイコンやビットマップなどの画像リソースをプレビュー表示します。

**業務上の目的・背景**：Windowsアプリケーションのリソース（アイコン、カーソル、ビットマップ、文字列等）へのアクセスは、ローカライズやリソース管理において重要な機能です。VBCorLibは.NET FrameworkのSystem.Resourcesと同様のAPIを提供し、VB6/VBAからも標準的なリソース操作が可能です。本画面は、リソース読み取り機能の使用方法を開発者に示すことを目的としています。

**画面へのアクセス方法**：Examples/IO Examples/ResourceBrowser/ResourceBrowser.vbpプロジェクトを開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. メニュー「File」→「Open RES」でRESファイルを開く
2. メニュー「File」→「Open EXE」でEXE/DLL/OCXファイルを開く
3. ListViewでリソース一覧を表示
4. リソースをクリックするとPictureBoxでプレビュー

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移はありません。

**権限による表示制御**：本画面は開発者向けデモツールであり、特別な権限制御は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | ResourceManager | 主機能 | リソースの管理とアクセス（リソース読み込みと表示） |
| 86 | ResourceReader | 主機能 | .resファイルからのリソース読み込み（NewResourceReader） |
| 89 | WinResourceReader | 主機能 | DLL/EXEからのWin32リソース読み込み（NewWinResourceReader） |
| 21 | Hashtable | 補助機能 | リソースのローカル保存（Add、Item） |
| 2 | CorString | 補助機能 | グループ情報のフォーマット表示（Format） |

## 画面種別

ブラウザ / 一覧・詳細表示

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Examples/IO Examples/ResourceBrowser/Form1.frm`

## 入出力項目

本画面は読み取り専用のブラウザ画面であり、データ入力機能はありません。

## 表示項目

### ListView1

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Name | String | リソース名（ID） |
| Type | String | リソース種別（Icon、Cursor、Bitmap等） |
| Language | Long | 言語ID |

### Picture1

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 画像プレビュー | StdPicture | アイコン、カーソル、ビットマップの表示 |
| グループ情報 | String | PictureResourceGroupの場合、メンバー詳細表示 |

## イベント仕様

### 1-Form_Load

フォーム読み込み時にListViewを初期化します。

**処理内容**:
1. Init関数を呼び出してListViewのカラムと表示設定を初期化

**コード参照**: 行195-197

```vb
Private Sub Form_Load()
    Call Init
End Sub
```

### 2-Init（内部関数）

ListViewを初期化します。

**処理内容**:
1. View = lvwReport（詳細表示）
2. FullRowSelect = True
3. LabelEdit = lvwManual
4. ColumnHeaders追加（Name、Type、Language）

**コード参照**: 行182-193

### 3-mnuFileOpenRes_Click

RESファイルを開きます。

**処理内容**:
1. GetFileNameでファイル選択ダイアログ表示
2. Cor.NewResourceReaderでResourceReaderを作成
3. LoadResourcesでリソースを読み込み・表示

**コード参照**: 行211-216

```vb
Private Sub mnuFileOpenRes_Click()
    Dim FileName As String
    FileName = GetFileName("Resource (*.RES)|*.RES")
    If Len(FileName) > 0 Then
        Call LoadResources(Cor.NewResourceReader(FileName))
    End If
End Sub
```

### 4-mnuFileOpenEXE_Click

EXE/DLL/OCXファイルを開きます。

**処理内容**:
1. GetFileNameでファイル選択ダイアログ表示
2. Cor.NewWinResourceReaderでWinResourceReaderを作成
3. LoadResourcesでリソースを読み込み・表示

**コード参照**: 行203-209

### 5-LoadResources（内部関数）

リソースを読み込んでListViewに表示します。

**処理内容**:
1. mResources.Clear、ListView1.ListItems.Clearでクリア
2. For Each Entry In Readerでリソースを列挙
3. ResourceKeyでキー情報取得
4. mResources.Addでローカル保存
5. ListView1.ListItems.Addで表示

**コード参照**: 行71-106

```vb
Private Sub LoadResources(ByVal Reader As IResourceReader)
    Call ClearException
    On Error GoTo errTrap

    Call mResources.Clear
    Call ListView1.ListItems.Clear

    Dim Entry As DictionaryEntry
    For Each Entry In Reader
        Dim Key As ResourceKey
        Set Key = Entry.Key

        Call mResources.Add(Key.ToString, Entry.Value)

        Dim Item As ListItem
        Set Item = ListView1.ListItems.Add(, Key.ToString, Key.ResourceName)
        Item.SubItems(1) = GetTypeName(Key.ResourceType)
        Item.SubItems(2) = Key.LanguageID
    Next Entry

    Reader.CloseReader

    Exit Sub

errTrap:
    Dim ex As Exception
    If Catch(ex) Then
        MsgBox ex.ToString, vbOKOnly + vbExclamation, "Error"
    End If
End Sub
```

### 6-ListView1_Click

リソースをクリックしたときプレビューを表示します。

**処理内容**:
1. ShowResourceを呼び出し、選択されたリソースを表示

**コード参照**: 行199-201

### 7-ShowResource（内部関数）

リソースをプレビュー表示します。

**処理内容**:
1. mResourcesからリソース取得
2. Picture1.Clsでクリア
3. StdPictureの場合はPaintPictureで描画
4. PictureResourceGroupの場合はグループ情報をテキスト表示
5. Stringの場合はそのまま表示

**コード参照**: 行108-144

### 8-GetTypeName（内部関数）

リソース種別を文字列に変換します。

**処理内容**:
1. 数値の場合はリソース定数（CursorResource等）と比較
2. 文字列の場合はそのまま返す

**コード参照**: 行153-180

## データベース更新仕様

本画面はデータベースを使用しません。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|-------------|---------------|----------|
| MSG-01 | Exception.ToString | ファイル読み込みエラー時 |

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| 無効なファイル形式 | Catch(ex)でExceptionをキャッチしMsgBox表示 |
| ファイル読み込みエラー | Catch(ex)でExceptionをキャッチしMsgBox表示 |

## 備考

- BorderStyle = Fixed Single（サイズ変更不可）
- MaxButton = False, MinButton = False（最大化・最小化ボタン無効）
- MSCOMCTL.OCX（ListView）を使用
- COMDLG32.OCX（CommonDialog）を使用
- mResources（Hashtable）でリソースをキー→値でローカル保存
- IResourceReaderインターフェースで抽象化（RES/EXE/DLL/OCX共通処理）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リソース管理で使用されるオブジェクトを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | 行67: mResources As New Hashtable |

**読解のコツ**: mResourcesはHashtableで、ResourceKeyのToString()をキー、リソース値（StdPicture、String等）を値として保持します。ListView1のクリック時にキーを使ってリソースを取得します。

#### Step 2: エントリーポイントを理解する

メニュー操作がエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | 行211-216: mnuFileOpenRes_Click |
| 2-2 | Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | 行203-209: mnuFileOpenEXE_Click |

**主要処理フロー**:
1. **行212-213**: GetFileNameでファイル選択
2. **行215**: Cor.NewResourceReaderでReader作成
3. **行215**: LoadResources(Reader)でリソース読み込み

#### Step 3: リソース読み込み処理を理解する

リソースの列挙と表示処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | 行71-106: LoadResources |

**主要処理フロー（LoadResources）**:
- **行79**: For Each Entry In Reader でリソース列挙
- **行82**: Set Key = Entry.Key でResourceKey取得
- **行85**: mResources.Add(Key.ToString, Entry.Value) でローカル保存
- **行89**: Key.ResourceName, GetTypeName, Key.LanguageID でListView表示

#### Step 4: リソース表示処理を理解する

リソースのプレビュー表示処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | 行108-144: ShowResource |

**主要処理フロー（ShowResource）**:
- **行112**: MoveVariant(Value, mResources(Key)) でリソース取得
- **行120-123**: StdPictureの場合はPaintPictureで描画
- **行125-133**: PictureResourceGroupの場合はグループ情報表示

### プログラム呼び出し階層図

```
mnuFileOpenRes_Click / mnuFileOpenEXE_Click
    │
    ├─ GetFileName(Filter)
    │      └─ CommonDialog.ShowOpen
    │
    └─ LoadResources(Reader)
           │
           ├─ mResources.Clear
           ├─ ListView1.ListItems.Clear
           │
           └─ For Each Entry In Reader
                  │
                  ├─ ResourceKey = Entry.Key
                  │
                  ├─ mResources.Add(Key.ToString, Entry.Value)
                  │
                  └─ ListView1.ListItems.Add
                         ├─ Key.ResourceName
                         ├─ GetTypeName(Key.ResourceType)
                         └─ Key.LanguageID

ListView1_Click
    │
    └─ ShowResource(ListView1.SelectedItem.Key)
           │
           ├─ MoveVariant(Value, mResources(Key))
           │
           └─ [型判定]
                  ├─ StdPicture → Picture1.PaintPicture
                  ├─ PictureResourceGroup → GetGroupInfo → Picture1.Print
                  └─ String → Picture1.Print
```

### データフロー図

```
[入力]                    [処理]                    [出力]

RESファイル ─────────▶ NewResourceReader ────────▶ IResourceReader
EXE/DLL/OCXファイル ─▶ NewWinResourceReader ────▶      │
                                                       ▼
                              For Each Entry ─────────▶ Entry.Key (ResourceKey)
                                                       Entry.Value (リソース値)
                                                            │
                                    ┌───────────────────────┤
                                    ▼                       ▼
                              mResources.Add         ListView1.ListItems.Add
                                    │                       │
                                    ▼                       ▼
                         [クリック時]               リソース一覧表示
                              │
                              ▼
                         ShowResource
                              │
                              ▼
                         Picture1 (プレビュー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/IO Examples/ResourceBrowser/Form1.frm` | ソース | メインフォーム |
| ResourceBrowser.vbp | `Examples/IO Examples/ResourceBrowser/ResourceBrowser.vbp` | プロジェクト | プロジェクト定義 |
| MSCOMCTL.OCX | 外部 | OCX | ListViewコントロール |
| COMDLG32.OCX | 外部 | OCX | CommonDialogコントロール |
| VBCorLib.dll | 外部 | DLL | VBCorLibライブラリ本体 |
